//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Diagnostics;
using System.Resources;
using System.Reflection;
using System.Globalization;
using System.Threading;

namespace GlobalApp
{
	/// <summary>
	/// Podsumowanie dla Form1.
	/// </summary>
	public class GlobalForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.ComboBox languageSelection;
		private System.Windows.Forms.PictureBox flagImage;
		private System.Windows.Forms.TextBox translatedText;
		private System.Windows.Forms.Button exit;
		private System.Windows.Forms.Label date;
		private System.Windows.Forms.Label calendar;
		private System.Windows.Forms.TextBox floatNumber;
		private System.Windows.Forms.TextBox currencyNumber;
		private System.Windows.Forms.Label localeID;
		private System.Windows.Forms.Label LCIDLabel;
		private System.Windows.Forms.Label calendarLabel;
		private System.Windows.Forms.Label dateLabel;
		private System.Windows.Forms.Label numberLabel;
		private System.Windows.Forms.Label currencyLabel;
		private System.Windows.Forms.Label metricLabel;
		private System.Windows.Forms.Label metric;
		private System.Windows.Forms.Label countryName;
		private System.Windows.Forms.Label reginoInfoLabel;
		private System.Windows.Forms.TextBox usersTextBox;
		private System.Windows.Forms.Label timeLabel;
		private System.Windows.Forms.Label time;
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public GlobalForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();

			ResourceManager rm = new ResourceManager("Strings", Assembly.GetExecutingAssembly());
			LanguageIdentifier[] lida = new LanguageIdentifier[] {
																	 new LanguageIdentifier((string)rm.GetString("ArabicSaudiArabia"), "ar-SA"),
																	 new LanguageIdentifier((string)rm.GetString("ArabicEgypt"), "ar-EG"),
																	 new LanguageIdentifier((string)rm.GetString("ArabicSyria"), "ar-SY"),
																	 new LanguageIdentifier((string)rm.GetString("German"), "de-DE"),
																	 new LanguageIdentifier((string)rm.GetString("GermanSwitzerland"), "de-CH"),
																	 new LanguageIdentifier((string)rm.GetString("GermanLuxembourg"), "de-LU"),
																	 new LanguageIdentifier((string)rm.GetString("GermanAustria"), "de-AT"),
																	 new LanguageIdentifier((string)rm.GetString("GermanLiechtenstein"), "de-LI"),
																	 new LanguageIdentifier((string)rm.GetString("Greek"), "el-GR"),
																	 new LanguageIdentifier((string)rm.GetString("Czech"), "cs-CZ"),
																	 new LanguageIdentifier((string)rm.GetString("Danish"), "da-DK"),
																	 new LanguageIdentifier((string)rm.GetString("Finnish"), "fi-FI"),
																	 new LanguageIdentifier((string)rm.GetString("Bulgarian"), "bg-BG"),
																	 new LanguageIdentifier((string)rm.GetString("Icelandic"), "is-IS"),
																	 new LanguageIdentifier((string)rm.GetString("Dutch"), "nl-NL"),
																	 new LanguageIdentifier((string)rm.GetString("Norwegian"), "nb-NO"),
																	 new LanguageIdentifier((string)rm.GetString("Polish"), "pl-PL"),
																	 new LanguageIdentifier((string)rm.GetString("Romanian"), "ro-RO"),
																	 new LanguageIdentifier((string)rm.GetString("Russian"), "ru-RU"),
																	 new LanguageIdentifier((string)rm.GetString("Croatian"), "hr-HR"),
																	 new LanguageIdentifier((string)rm.GetString("Albanian"), "sq-AL"),
																	 new LanguageIdentifier((string)rm.GetString("Swedish"), "sv-SE"),
																	 new LanguageIdentifier((string)rm.GetString("Indonesian"), "id-ID"),
																	 new LanguageIdentifier((string)rm.GetString("Ukrainian"), "uk-UA"),
																	 new LanguageIdentifier((string)rm.GetString("Sanskrit"), "sa-IN"),
																	 new LanguageIdentifier((string)rm.GetString("Tamil"), "ta-IN"),
																	 new LanguageIdentifier((string)rm.GetString("Marathi"), "mr-IN"),
																	 new LanguageIdentifier((string)rm.GetString("Kannada"), "kn-IN"),
																	 new LanguageIdentifier((string)rm.GetString("Telugu"), "te-IN"),
																	 new LanguageIdentifier((string)rm.GetString("EnglishAustralia"), "en-AU"),
																	 new LanguageIdentifier((string)rm.GetString("EnglishNewZealand"), "en-NZ"),
																	 new LanguageIdentifier((string)rm.GetString("EnglishCanada"), "en-CA"),
																	 new LanguageIdentifier((string)rm.GetString("EnglishUnitedKingdom"), "en-GB"),
																	 new LanguageIdentifier((string)rm.GetString("EnglishUS"), "en-US"),
																	 new LanguageIdentifier((string)rm.GetString("EnglishIreland"), "en-IE"),
																	 new LanguageIdentifier((string)rm.GetString("EnglishSouthAfrica"), "en-ZA"),
																	 new LanguageIdentifier((string)rm.GetString("EnglishJamaica"), "en-JM"),
																	 new LanguageIdentifier((string)rm.GetString("EnglishBelize"), "en-BZ"),
																	 new LanguageIdentifier((string)rm.GetString("EnglishTrinidadTobago"), "en-TT"),
																	 new LanguageIdentifier((string)rm.GetString("EnglishZimbabwe"), "en-ZW"),
																	 new LanguageIdentifier((string)rm.GetString("EnglishPhilippines"), "en-PH"),
																	 new LanguageIdentifier((string)rm.GetString("SpanishSpain"), "es-ES"),
																	 new LanguageIdentifier((string)rm.GetString("SpanishMexico"), "es-MX"),
																	 new LanguageIdentifier((string)rm.GetString("SpanishGuatemala"), "es-GT"),
																	 new LanguageIdentifier((string)rm.GetString("SpanishCostaRica"), "es-CR"),
																	 new LanguageIdentifier((string)rm.GetString("SpanishPanama"), "es-PA"),
																	 new LanguageIdentifier((string)rm.GetString("SpanishArgentina"), "es-AR"),
																	 new LanguageIdentifier((string)rm.GetString("French"), "fr-FR"),
																	 new LanguageIdentifier((string)rm.GetString("Hebrew"), "he-IL"),
																	 new LanguageIdentifier((string)rm.GetString("Hindi"), "hi-IN"),
																	 new LanguageIdentifier((string)rm.GetString("Armenian"), "hy-AM"),
																	 new LanguageIdentifier((string)rm.GetString("Italian"), "it-IT"),
																	 new LanguageIdentifier((string)rm.GetString("Japanese"), "ja-JP"),
																	 new LanguageIdentifier((string)rm.GetString("KoreanSouthKorea"), "ko-KR"),
																	 new LanguageIdentifier((string)rm.GetString("KoreanNorthKorea"), "ko-KP"),
																	 new LanguageIdentifier((string)rm.GetString("Thai"), "th-TH"),
																	 new LanguageIdentifier((string)rm.GetString("Turkish"), "tr-TR"),
																	 new LanguageIdentifier((string)rm.GetString("Urdu"), "ur-PK"),
																	 new LanguageIdentifier((string)rm.GetString("Vietnamese"), "vi-VN"),
																	 new LanguageIdentifier((string)rm.GetString("ChinesePRC"), "zh-CN"),
																	 new LanguageIdentifier((string)rm.GetString("ChineseTaiwan"), "zh-TW"),
																	 new LanguageIdentifier((string)rm.GetString("ChineseSingapore"), "zh-SG")
																 };
			languageSelection.Items.AddRange(lida);

			rm = new ResourceManager("Flags", this.GetType().Assembly);
			flagImage.Image = (System.Drawing.Image)rm.GetObject("flag");
			rm = new ResourceManager("Translation", this.GetType().Assembly);
			translatedText.Text = (string)rm.GetObject("question");
		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			ResourceManager resources = new ResourceManager("GlobalApp",  this.GetType().Assembly);
			this.flagImage = new System.Windows.Forms.PictureBox();
			this.date = new System.Windows.Forms.Label();
			this.currencyNumber = new System.Windows.Forms.TextBox();
			this.metric = new System.Windows.Forms.Label();
			this.countryName = new System.Windows.Forms.Label();
			this.LCIDLabel = new System.Windows.Forms.Label();
			this.metricLabel = new System.Windows.Forms.Label();
			this.usersTextBox = new System.Windows.Forms.TextBox();
			this.numberLabel = new System.Windows.Forms.Label();
			this.floatNumber = new System.Windows.Forms.TextBox();
			this.languageSelection = new System.Windows.Forms.ComboBox();
			this.dateLabel = new System.Windows.Forms.Label();
			this.calendar = new System.Windows.Forms.Label();
			this.calendarLabel = new System.Windows.Forms.Label();
			this.translatedText = new System.Windows.Forms.TextBox();
			this.localeID = new System.Windows.Forms.Label();
			this.currencyLabel = new System.Windows.Forms.Label();
			this.exit = new System.Windows.Forms.Button();
			this.reginoInfoLabel = new System.Windows.Forms.Label();
			this.timeLabel = new System.Windows.Forms.Label();
			this.time = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// flagImage
			// 
			this.flagImage.ImeMode = System.Windows.Forms.ImeMode.NoControl;
			this.flagImage.Location = new System.Drawing.Point(15, 61);
			this.flagImage.Name = "flagImage";
			this.flagImage.Size = new System.Drawing.Size(358, 250);
			this.flagImage.TabIndex = 1;
			this.flagImage.TabStop = false;
			// 
			// date
			// 
			this.date.ImeMode = System.Windows.Forms.ImeMode.NoControl;
			this.date.Location = new System.Drawing.Point(384, 128);
			this.date.Name = "date";
			this.date.Size = new System.Drawing.Size(160, 16);
			this.date.TabIndex = 5;
			// 
			// currencyNumber
			// 
			this.currencyNumber.Location = new System.Drawing.Point(384, 232);
			this.currencyNumber.Name = "currencyNumber";
			this.currencyNumber.ReadOnly = true;
			this.currencyNumber.Size = new System.Drawing.Size(168, 25);
			this.currencyNumber.TabIndex = 8;
			this.currencyNumber.Text = "";
			// 
			// metric
			// 
			this.metric.ImeMode = System.Windows.Forms.ImeMode.NoControl;
			this.metric.Location = new System.Drawing.Point(440, 288);
			this.metric.Name = "metric";
			this.metric.Size = new System.Drawing.Size(48, 16);
			this.metric.TabIndex = 16;
			// 
			// countryName
			// 
			this.countryName.ImeMode = System.Windows.Forms.ImeMode.NoControl;
			this.countryName.Location = new System.Drawing.Point(384, 312);
			this.countryName.Name = "countryName";
			this.countryName.Size = new System.Drawing.Size(176, 16);
			this.countryName.TabIndex = 17;
			// 
			// LCIDLabel
			// 
			this.LCIDLabel.ImeMode = System.Windows.Forms.ImeMode.NoControl;
			this.LCIDLabel.Location = new System.Drawing.Point(256, 8);
			this.LCIDLabel.Name = "LCIDLabel";
			this.LCIDLabel.Size = new System.Drawing.Size(100, 16);
			this.LCIDLabel.TabIndex = 10;
			this.LCIDLabel.Text = "LCID";
			// 
			// metricLabel
			// 
			this.metricLabel.ImeMode = System.Windows.Forms.ImeMode.NoControl;
			this.metricLabel.Location = new System.Drawing.Point(384, 288);
			this.metricLabel.Name = "metricLabel";
			this.metricLabel.Size = new System.Drawing.Size(48, 16);
			this.metricLabel.TabIndex = 15;
			this.metricLabel.Text = "System metryczny?";
			// 
			// usersTextBox
			// 
			this.usersTextBox.ImeMode = System.Windows.Forms.ImeMode.On;
			this.usersTextBox.Location = new System.Drawing.Point(184, 376);
			this.usersTextBox.Name = "usersTextBox";
			this.usersTextBox.Size = new System.Drawing.Size(320, 25);
			this.usersTextBox.TabIndex = 19;
			this.usersTextBox.Text = "";
			// 
			// numberLabel
			// 
			this.numberLabel.ImeMode = System.Windows.Forms.ImeMode.NoControl;
			this.numberLabel.Location = new System.Drawing.Point(384, 152);
			this.numberLabel.Name = "numberLabel";
			this.numberLabel.Size = new System.Drawing.Size(100, 16);
			this.numberLabel.TabIndex = 13;
			this.numberLabel.Text = "Liczba";
			// 
			// floatNumber
			// 
			this.floatNumber.Location = new System.Drawing.Point(384, 176);
			this.floatNumber.Name = "floatNumber";
			this.floatNumber.ReadOnly = true;
			this.floatNumber.Size = new System.Drawing.Size(168, 25);
			this.floatNumber.TabIndex = 7;
			this.floatNumber.Text = "";
			// 
			// languageSelection
			// 
			this.languageSelection.DropDownWidth = 200;
			this.languageSelection.ItemHeight = 18;
			this.languageSelection.Location = new System.Drawing.Point(15, 23);
			this.languageSelection.Name = "languageSelection";
			this.languageSelection.Size = new System.Drawing.Size(182, 26);
			this.languageSelection.TabIndex = 0;
			this.languageSelection.SelectionChangeCommitted += new System.EventHandler(this.OnSelectionChangeCommited);
			// 
			// dateLabel
			// 
			this.dateLabel.ImeMode = System.Windows.Forms.ImeMode.NoControl;
			this.dateLabel.Location = new System.Drawing.Point(384, 104);
			this.dateLabel.Name = "dateLabel";
			this.dateLabel.Size = new System.Drawing.Size(100, 16);
			this.dateLabel.TabIndex = 12;
			this.dateLabel.Text = "Dzisiejsza data";
			// 
			// calendar
			// 
			this.calendar.ImeMode = System.Windows.Forms.ImeMode.NoControl;
			this.calendar.Location = new System.Drawing.Point(384, 32);
			this.calendar.Name = "calendar";
			this.calendar.Size = new System.Drawing.Size(96, 16);
			this.calendar.TabIndex = 6;
			// 
			// calendarLabel
			// 
			this.calendarLabel.ImeMode = System.Windows.Forms.ImeMode.NoControl;
			this.calendarLabel.Location = new System.Drawing.Point(384, 8);
			this.calendarLabel.Name = "calendarLabel";
			this.calendarLabel.Size = new System.Drawing.Size(100, 16);
			this.calendarLabel.TabIndex = 11;
			this.calendarLabel.Text = "Rodzaj kalendarza";
			// 
			// translatedText
			// 
			this.translatedText.Font = new System.Drawing.Font("Arial Unicode MS", 12F, System.Drawing.FontStyle.Bold);
			this.translatedText.Location = new System.Drawing.Point(7, 333);
			this.translatedText.Name = "translatedText";
			this.translatedText.Size = new System.Drawing.Size(497, 29);
			this.translatedText.TabIndex = 2;
			this.translatedText.Text = "";
			// 
			// localeID
			// 
			this.localeID.ImeMode = System.Windows.Forms.ImeMode.NoControl;
			this.localeID.Location = new System.Drawing.Point(256, 32);
			this.localeID.Name = "localeID";
			this.localeID.Size = new System.Drawing.Size(100, 16);
			this.localeID.TabIndex = 9;
			// 
			// currencyLabel
			// 
			this.currencyLabel.ImeMode = System.Windows.Forms.ImeMode.NoControl;
			this.currencyLabel.Location = new System.Drawing.Point(384, 208);
			this.currencyLabel.Name = "currencyLabel";
			this.currencyLabel.Size = new System.Drawing.Size(100, 16);
			this.currencyLabel.TabIndex = 14;
			this.currencyLabel.Text = "Waluta";
			// 
			// exit
			// 
			this.exit.ImeMode = System.Windows.Forms.ImeMode.NoControl;
			this.exit.Location = new System.Drawing.Point(8, 379);
			this.exit.Name = "exit";
			this.exit.Size = new System.Drawing.Size(69, 21);
			this.exit.TabIndex = 4;
			this.exit.Text = "Wyjd";
			this.exit.Click += new System.EventHandler(this.OnExit);
			// 
			// reginoInfoLabel
			// 
			this.reginoInfoLabel.BackColor = System.Drawing.SystemColors.Desktop;
			this.reginoInfoLabel.ImeMode = System.Windows.Forms.ImeMode.NoControl;
			this.reginoInfoLabel.Location = new System.Drawing.Point(384, 264);
			this.reginoInfoLabel.Name = "reginoInfoLabel";
			this.reginoInfoLabel.Size = new System.Drawing.Size(168, 16);
			this.reginoInfoLabel.TabIndex = 18;
			this.reginoInfoLabel.Text = "Informacje o regionie";
			this.reginoInfoLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// timeLabel
			// 
			this.timeLabel.Location = new System.Drawing.Point(384, 56);
			this.timeLabel.Name = "timeLabel";
			this.timeLabel.Size = new System.Drawing.Size(48, 16);
			this.timeLabel.TabIndex = 20;
			this.timeLabel.Text = "Czas";
			// 
			// time
			// 
			this.time.Location = new System.Drawing.Point(384, 80);
			this.time.Name = "time";
			this.time.Size = new System.Drawing.Size(160, 16);
			this.time.TabIndex = 21;
			// 
			// GlobalForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 18);
			this.ClientSize = new System.Drawing.Size(562, 408);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.time,
																		  this.timeLabel,
																		  this.usersTextBox,
																		  this.reginoInfoLabel,
																		  this.countryName,
																		  this.metric,
																		  this.metricLabel,
																		  this.currencyLabel,
																		  this.numberLabel,
																		  this.dateLabel,
																		  this.calendarLabel,
																		  this.LCIDLabel,
																		  this.localeID,
																		  this.currencyNumber,
																		  this.floatNumber,
																		  this.calendar,
																		  this.date,
																		  this.exit,
																		  this.translatedText,
																		  this.flagImage,
																		  this.languageSelection});
			this.Font = new System.Drawing.Font("Arial Unicode MS", 9.75F);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Name = "GlobalForm";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Thread.CurrentThread.CurrentCulture = new CultureInfo("en-US");
			Thread.CurrentThread.CurrentUICulture = Thread.CurrentThread.CurrentCulture;
			Application.Run(new GlobalForm());
		}

		private void OnExit(object sender, System.EventArgs e)
		{
			Application.Exit();
		}

		private void OnSound(object sender, System.EventArgs e)
		{

		}

		private void OnSelectionChangeCommited(object sender, System.EventArgs e)
		{
			try
			{
				LanguageIdentifier li = (LanguageIdentifier)languageSelection.SelectedItem;
				Text = "GlobalApp " + li.Message;
				Thread.CurrentThread.CurrentUICulture = new CultureInfo(li.CultureString);
				Thread.CurrentThread.CurrentCulture = Thread.CurrentThread.CurrentUICulture;
				ResourceManager rm = new ResourceManager("Flags", this.GetType().Assembly);
				flagImage.Image = (System.Drawing.Image)rm.GetObject("flag");
				rm = new ResourceManager("Translation", this.GetType().Assembly);
				translatedText.Text = (string)rm.GetObject("question");
				string audio = (string)rm.GetObject("audio");
				audio = audio.Trim();
				if(audio.Length > 0)
				{
					Process.Start(li.CultureString + @"\" + audio);
				}
				CultureInfo ci = Thread.CurrentThread.CurrentUICulture;

				// Informacje lokalne
				localeID.Text = Convert.ToString(ci.LCID);

				// Kalendarz
				if(ci.Calendar is GregorianCalendar)
				{
					calendar.Text = "Gregoriaski";
				}
				else if(ci.Calendar is HebrewCalendar)
				{
					calendar.Text = "ydowski";
				}
				else if(ci.Calendar is HijriCalendar)
				{
					calendar.Text = "Hijri";
				}
				else if(ci.Calendar is JapaneseCalendar)
				{
					calendar.Text = "Japoski";
				}
				else if(ci.Calendar is JulianCalendar)
				{
					calendar.Text = "Juliaski";
				}
				else if(ci.Calendar is KoreanCalendar)
				{
					calendar.Text = "Koreaski";
				}
				else if(ci.Calendar is TaiwanCalendar)
				{
					calendar.Text = "Tajwaski";
				}
				else if(ci.Calendar is ThaiBuddhistCalendar)
				{
					calendar.Text = "Tajski";
				}
				else
				{
					calendar.Text = "";

				}
				DateTime now = DateTime.Now;
				time.Text = now.ToLongTimeString();
				date.Text = now.ToLongDateString();
				double d = 1000000.0;
				floatNumber.Text = String.Format("{0:N}", d);
				currencyNumber.Text = String.Format("{0:C}", d);

				// Informacje o regionie
				RegionInfo ri = new RegionInfo(ci.LCID);
				metric.Text = Convert.ToString(ri.IsMetric);
				countryName.Text = ri.DisplayName;

			}
			catch(Exception exception)
			{
				Debug.WriteLine(exception);
			}
		}
	}
}
